/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.internal.ByteBufferWrapper;
import com.sun.j3d.internal.ByteOrderWrapper;
import com.sun.j3d.internal.FloatBufferWrapper;
import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.utils.geometry.GeometryInfoGenerator;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Triangulator;
import java.util.HashMap;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.IndexedQuadArray;
import javax.media.j3d.IndexedTriangleArray;
import javax.media.j3d.IndexedTriangleFanArray;
import javax.media.j3d.IndexedTriangleStripArray;
import javax.media.j3d.QuadArray;
import javax.media.j3d.TriangleArray;
import javax.media.j3d.TriangleFanArray;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Color3b;
import javax.vecmath.Color3f;
import javax.vecmath.Color4b;
import javax.vecmath.Color4f;
import javax.vecmath.Point2f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.TexCoord3f;
import javax.vecmath.TexCoord4f;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;

public class GeometryInfo {
    public static final int TRIANGLE_ARRAY = 1;
    public static final int QUAD_ARRAY = 2;
    public static final int TRIANGLE_FAN_ARRAY = 3;
    public static final int TRIANGLE_STRIP_ARRAY = 4;
    public static final int POLYGON_ARRAY = 5;
    private int prim;
    private static final int DEBUG = 0;
    private Point3f[] coordinates = null;
    private Color3f[] colors3 = null;
    private Color4f[] colors4 = null;
    private Vector3f[] normals = null;
    private Object[][] texCoordSets = null;
    private int[] coordinateIndices = null;
    private int[] colorIndices = null;
    private int[] normalIndices = null;
    private int[][] texCoordIndexSets = null;
    private int[] texCoordSetMap = null;
    private int texCoordSetCount = 0;
    private int texCoordDim = 0;
    private int[] stripCounts = null;
    private int[] contourCounts = null;
    private Triangulator tr = null;
    private NormalGenerator ng = null;
    private int oldPrim = 0;
    private int[] oldStripCounts = null;
    private boolean coordOnly = false;

    public GeometryInfo(int n2) {
        if (n2 < 1 || n2 > 5) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo0"));
        }
        this.prim = n2;
    }

    public GeometryInfo(GeometryArray geometryArray) {
        GeometryInfoGenerator.create(this, geometryArray);
    }

    public void reset(int n2) {
        if (n2 < 1 || n2 > 5) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo0"));
        }
        this.prim = n2;
        this.coordinates = null;
        this.colors3 = null;
        this.colors4 = null;
        this.normals = null;
        this.coordinateIndices = null;
        this.colorIndices = null;
        this.normalIndices = null;
        this.stripCounts = null;
        this.contourCounts = null;
        this.oldPrim = 0;
        this.oldStripCounts = null;
        this.texCoordDim = 0;
        this.texCoordSetCount = 0;
        this.texCoordSets = null;
        this.texCoordIndexSets = null;
        this.texCoordSetMap = null;
        this.coordOnly = false;
    }

    public void reset(GeometryArray geometryArray) {
        GeometryInfoGenerator.create(this, geometryArray);
    }

    private int[] expandQuad(int[] nArray) {
        int[] nArray2 = new int[nArray.length / 4 * 6];
        for (int i2 = 0; i2 < nArray.length / 4; ++i2) {
            nArray2[i2 * 6 + 0] = nArray[i2 * 4];
            nArray2[i2 * 6 + 1] = nArray[i2 * 4 + 1];
            nArray2[i2 * 6 + 2] = nArray[i2 * 4 + 2];
            nArray2[i2 * 6 + 3] = nArray[i2 * 4];
            nArray2[i2 * 6 + 4] = nArray[i2 * 4 + 2];
            nArray2[i2 * 6 + 5] = nArray[i2 * 4 + 3];
        }
        return nArray2;
    }

    private int[] expandTriFan(int n2, int[] nArray) {
        int[] nArray2 = new int[n2 * 3];
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < this.stripCounts.length; ++i2) {
            for (int i3 = 0; i3 < this.stripCounts[i2] - 2; ++i3) {
                nArray2[n3++] = nArray[n4];
                nArray2[n3++] = nArray[n4 + i3 + 1];
                nArray2[n3++] = nArray[n4 + i3 + 2];
            }
            n4 += this.stripCounts[i2];
        }
        return nArray2;
    }

    private int[] expandTriStrip(int n2, int[] nArray) {
        int[] nArray2 = new int[n2 * 3];
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < this.stripCounts.length; ++i2) {
            for (int i3 = 0; i3 < this.stripCounts[i2] - 2; ++i3) {
                if (i3 % 2 == 0) {
                    nArray2[n3++] = nArray[n4 + i3 + 0];
                    nArray2[n3++] = nArray[n4 + i3 + 1];
                    nArray2[n3++] = nArray[n4 + i3 + 2];
                    continue;
                }
                nArray2[n3++] = nArray[n4 + i3 + 0];
                nArray2[n3++] = nArray[n4 + i3 + 2];
                nArray2[n3++] = nArray[n4 + i3 + 1];
            }
            n4 += this.stripCounts[i2];
        }
        return nArray2;
    }

    void rememberOldPrim() {
        this.oldPrim = this.prim;
        this.oldStripCounts = this.stripCounts;
    }

    int getOldPrim() {
        return this.oldPrim;
    }

    void forgetOldPrim() {
        this.oldPrim = 0;
        this.oldStripCounts = null;
    }

    private void changeBackToOldPrim() {
        if (this.oldPrim != 0) {
            this.convertToIndexedTriangles();
            if (this.ng == null) {
                this.ng = new NormalGenerator();
            }
            this.ng.convertBackToOldPrim(this, this.oldPrim, this.oldStripCounts);
            this.oldPrim = 0;
            this.oldStripCounts = null;
        }
    }

    public void convertToIndexedTriangles() {
        int n2 = 0;
        this.indexify();
        if (this.prim == 1) {
            return;
        }
        switch (this.prim) {
            case 2: {
                this.coordinateIndices = this.expandQuad(this.coordinateIndices);
                if (this.colorIndices != null) {
                    this.colorIndices = this.expandQuad(this.colorIndices);
                }
                if (this.normalIndices != null) {
                    this.normalIndices = this.expandQuad(this.normalIndices);
                }
                for (int i2 = 0; i2 < this.texCoordSetCount; ++i2) {
                    this.texCoordIndexSets[i2] = this.expandQuad(this.texCoordIndexSets[i2]);
                }
                break;
            }
            case 3: {
                int n3;
                for (n3 = 0; n3 < this.stripCounts.length; ++n3) {
                    n2 += this.stripCounts[n3] - 2;
                }
                this.coordinateIndices = this.expandTriFan(n2, this.coordinateIndices);
                if (this.colorIndices != null) {
                    this.colorIndices = this.expandTriFan(n2, this.colorIndices);
                }
                if (this.normalIndices != null) {
                    this.normalIndices = this.expandTriFan(n2, this.normalIndices);
                }
                for (n3 = 0; n3 < this.texCoordSetCount; ++n3) {
                    this.texCoordIndexSets[n3] = this.expandTriFan(n2, this.texCoordIndexSets[n3]);
                }
                break;
            }
            case 4: {
                int n4;
                for (n4 = 0; n4 < this.stripCounts.length; ++n4) {
                    n2 += this.stripCounts[n4] - 2;
                }
                this.coordinateIndices = this.expandTriStrip(n2, this.coordinateIndices);
                if (this.colorIndices != null) {
                    this.colorIndices = this.expandTriStrip(n2, this.colorIndices);
                }
                if (this.normalIndices != null) {
                    this.normalIndices = this.expandTriStrip(n2, this.normalIndices);
                }
                for (n4 = 0; n4 < this.texCoordSetCount; ++n4) {
                    this.texCoordIndexSets[n4] = this.expandTriStrip(n2, this.texCoordIndexSets[n4]);
                }
                break;
            }
            case 5: {
                if (this.tr == null) {
                    this.tr = new Triangulator();
                }
                this.tr.triangulate(this);
            }
        }
        this.prim = 1;
        this.stripCounts = null;
    }

    public int getPrimitive() {
        return this.prim;
    }

    void setPrimitive(int n2) {
        if (this.prim < 1 || this.prim > 5) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo0"));
        }
        this.prim = n2;
    }

    public void setCoordinates(Point3f[] point3fArray) {
        this.coordinates = point3fArray;
    }

    public void setCoordinates(Point3d[] point3dArray) {
        if (point3dArray == null) {
            this.coordinates = null;
        } else {
            this.coordinates = new Point3f[point3dArray.length];
            for (int i2 = 0; i2 < point3dArray.length; ++i2) {
                this.coordinates[i2] = new Point3f((float)point3dArray[i2].x, (float)point3dArray[i2].y, (float)point3dArray[i2].z);
            }
        }
    }

    public void setCoordinates(float[] fArray) {
        if (fArray == null) {
            this.coordinates = null;
        } else {
            this.coordinates = new Point3f[fArray.length / 3];
            for (int i2 = 0; i2 < this.coordinates.length; ++i2) {
                this.coordinates[i2] = new Point3f(fArray[i2 * 3], fArray[i2 * 3 + 1], fArray[i2 * 3 + 2]);
            }
        }
    }

    public void setCoordinates(double[] dArray) {
        if (dArray == null) {
            this.coordinates = null;
        } else {
            this.coordinates = new Point3f[dArray.length / 3];
            for (int i2 = 0; i2 < dArray.length / 3; ++i2) {
                this.coordinates[i2] = new Point3f((float)dArray[i2 * 3], (float)dArray[i2 * 3 + 1], (float)dArray[i2 * 3 + 2]);
            }
        }
    }

    public Point3f[] getCoordinates() {
        return this.coordinates;
    }

    public void setColors(Color3f[] color3fArray) {
        this.colors3 = color3fArray;
        this.colors4 = null;
    }

    public void setColors(Color4f[] color4fArray) {
        this.colors3 = null;
        this.colors4 = color4fArray;
    }

    public void setColors(Color3b[] color3bArray) {
        if (color3bArray == null) {
            this.colors3 = null;
            this.colors4 = null;
        } else {
            this.colors3 = new Color3f[color3bArray.length];
            this.colors4 = null;
            for (int i2 = 0; i2 < color3bArray.length; ++i2) {
                this.colors3[i2] = new Color3f((float)(color3bArray[i2].x & 0xFF) / 255.0f, (float)(color3bArray[i2].y & 0xFF) / 255.0f, (float)(color3bArray[i2].z & 0xFF) / 255.0f);
            }
        }
    }

    public void setColors(Color4b[] color4bArray) {
        if (color4bArray == null) {
            this.colors3 = null;
            this.colors4 = null;
        } else {
            this.colors3 = null;
            this.colors4 = new Color4f[color4bArray.length];
            for (int i2 = 0; i2 < color4bArray.length; ++i2) {
                this.colors4[i2] = new Color4f((float)(color4bArray[i2].x & 0xFF) / 255.0f, (float)(color4bArray[i2].y & 0xFF) / 255.0f, (float)(color4bArray[i2].z & 0xFF) / 255.0f, (float)(color4bArray[i2].w & 0xFF) / 255.0f);
            }
        }
    }

    public void setColors3(float[] fArray) {
        if (fArray == null) {
            this.colors3 = null;
            this.colors4 = null;
        } else {
            this.colors3 = new Color3f[fArray.length / 3];
            this.colors4 = null;
            for (int i2 = 0; i2 < fArray.length / 3; ++i2) {
                this.colors3[i2] = new Color3f(fArray[i2 * 3], fArray[i2 * 3 + 1], fArray[i2 * 3 + 2]);
            }
        }
    }

    public void setColors4(float[] fArray) {
        if (fArray == null) {
            this.colors3 = null;
            this.colors4 = null;
        } else {
            this.colors3 = null;
            this.colors4 = new Color4f[fArray.length / 4];
            for (int i2 = 0; i2 < fArray.length / 4; ++i2) {
                this.colors4[i2] = new Color4f(fArray[i2 * 4], fArray[i2 * 4 + 1], fArray[i2 * 4 + 2], fArray[i2 * 4 + 3]);
            }
        }
    }

    public void setColors3(byte[] byArray) {
        if (byArray == null) {
            this.colors3 = null;
            this.colors4 = null;
        } else {
            this.colors3 = new Color3f[byArray.length / 3];
            this.colors4 = null;
            for (int i2 = 0; i2 < byArray.length / 3; ++i2) {
                this.colors3[i2] = new Color3f((float)(byArray[i2 * 3] & 0xFF) / 255.0f, (float)(byArray[i2 * 3 + 1] & 0xFF) / 255.0f, (float)(byArray[i2 * 3 + 2] & 0xFF) / 255.0f);
            }
        }
    }

    public void setColors4(byte[] byArray) {
        if (byArray == null) {
            this.colors3 = null;
            this.colors4 = null;
        } else {
            this.colors3 = null;
            this.colors4 = new Color4f[byArray.length / 4];
            for (int i2 = 0; i2 < byArray.length / 4; ++i2) {
                this.colors4[i2] = new Color4f((float)(byArray[i2 * 4] & 0xFF) / 255.0f, (float)(byArray[i2 * 4 + 1] & 0xFF) / 255.0f, (float)(byArray[i2 * 4 + 2] & 0xFF) / 255.0f, (float)(byArray[i2 * 4 + 3] & 0xFF) / 255.0f);
            }
        }
    }

    public Object[] getColors() {
        if (this.colors3 != null) {
            return this.colors3;
        }
        return this.colors4;
    }

    public int getNumColorComponents() {
        if (this.colors3 != null) {
            return 3;
        }
        if (this.colors4 != null) {
            return 4;
        }
        return 0;
    }

    public void setNormals(Vector3f[] vector3fArray) {
        this.normals = vector3fArray;
    }

    public void setNormals(float[] fArray) {
        if (fArray == null) {
            this.normals = null;
        } else {
            this.normals = new Vector3f[fArray.length / 3];
            for (int i2 = 0; i2 < this.normals.length; ++i2) {
                this.normals[i2] = new Vector3f(fArray[i2 * 3], fArray[i2 * 3 + 1], fArray[i2 * 3 + 2]);
            }
        }
    }

    public Vector3f[] getNormals() {
        return this.normals;
    }

    public void setTextureCoordinateParams(int n2, int n3) {
        if (n3 == 2) {
            this.texCoordSets = new TexCoord2f[n2][];
        } else if (n3 == 3) {
            this.texCoordSets = new TexCoord3f[n2][];
        } else if (n3 == 4) {
            this.texCoordSets = new TexCoord4f[n2][];
        } else {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo9"));
        }
        this.texCoordIndexSets = new int[n2][];
        this.texCoordDim = n3;
        this.texCoordSetCount = n2;
    }

    public int getTexCoordSetCount() {
        return this.texCoordSetCount;
    }

    public int getNumTexCoordComponents() {
        return this.texCoordDim;
    }

    public void setTexCoordSetMap(int[] nArray) {
        this.texCoordSetMap = nArray;
    }

    public int[] getTexCoordSetMap() {
        return this.texCoordSetMap;
    }

    public void setTextureCoordinates(int n2, TexCoord2f[] texCoord2fArray) {
        if (this.texCoordDim != 2) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo15"));
        }
        if (n2 >= this.texCoordSetCount || n2 < 0) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo18"));
        }
        this.texCoordSets[n2] = texCoord2fArray;
    }

    public void setTextureCoordinates(Point2f[] point2fArray) {
        this.texCoordSetCount = 1;
        this.texCoordDim = 2;
        this.texCoordSets = new TexCoord2f[1][];
        if (point2fArray != null) {
            TexCoord2f[] texCoord2fArray = new TexCoord2f[point2fArray.length];
            for (int i2 = 0; i2 < point2fArray.length; ++i2) {
                texCoord2fArray[i2] = new TexCoord2f(point2fArray[i2]);
            }
            this.texCoordSets[0] = texCoord2fArray;
        }
    }

    public void setTextureCoordinates(int n2, TexCoord3f[] texCoord3fArray) {
        if (this.texCoordDim != 3) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo16"));
        }
        if (n2 >= this.texCoordSetCount || n2 < 0) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo18"));
        }
        this.texCoordSets[n2] = texCoord3fArray;
    }

    public void setTextureCoordinates(Point3f[] point3fArray) {
        this.texCoordSetCount = 1;
        this.texCoordDim = 3;
        this.texCoordSets = new TexCoord3f[1][];
        if (point3fArray != null) {
            TexCoord3f[] texCoord3fArray = new TexCoord3f[point3fArray.length];
            for (int i2 = 0; i2 < point3fArray.length; ++i2) {
                texCoord3fArray[i2] = new TexCoord3f(point3fArray[i2]);
            }
            this.texCoordSets[0] = texCoord3fArray;
        }
    }

    public void setTextureCoordinates(int n2, TexCoord4f[] texCoord4fArray) {
        if (this.texCoordDim != 4) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo17"));
        }
        if (n2 >= this.texCoordSetCount || n2 < 0) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo18"));
        }
        this.texCoordSets[n2] = texCoord4fArray;
    }

    public void setTextureCoordinates(int n2, float[] fArray) {
        if (fArray.length % this.texCoordDim != 0) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo2"));
        }
        if (this.texCoordDim == 2) {
            TexCoord2f[] texCoord2fArray = new TexCoord2f[fArray.length / 2];
            for (int i2 = 0; i2 < texCoord2fArray.length; ++i2) {
                texCoord2fArray[i2] = new TexCoord2f(fArray[i2 * 2], fArray[i2 * 2 + 1]);
            }
            this.setTextureCoordinates(n2, texCoord2fArray);
        } else if (this.texCoordDim == 3) {
            TexCoord3f[] texCoord3fArray = new TexCoord3f[fArray.length / 3];
            for (int i3 = 0; i3 < texCoord3fArray.length; ++i3) {
                texCoord3fArray[i3] = new TexCoord3f(fArray[i3 * 3], fArray[i3 * 3 + 1], fArray[i3 * 3 + 2]);
            }
            this.setTextureCoordinates(n2, texCoord3fArray);
        } else if (this.texCoordDim == 4) {
            TexCoord4f[] texCoord4fArray = new TexCoord4f[fArray.length / 4];
            for (int i4 = 0; i4 < texCoord4fArray.length; ++i4) {
                texCoord4fArray[i4] = new TexCoord4f(fArray[i4 * 4], fArray[i4 * 4 + 1], fArray[i4 * 4 + 2], fArray[i4 * 4 + 3]);
            }
            this.setTextureCoordinates(n2, texCoord4fArray);
        } else {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo21"));
        }
    }

    public void setTextureCoordinates2(float[] fArray) {
        this.texCoordSetCount = 1;
        this.texCoordDim = 2;
        this.texCoordSets = new TexCoord2f[1][];
        this.setTextureCoordinates(0, fArray);
    }

    public void setTextureCoordinates3(float[] fArray) {
        this.texCoordSetCount = 1;
        this.texCoordDim = 3;
        this.texCoordSets = new TexCoord3f[1][];
        this.setTextureCoordinates(0, fArray);
    }

    public Object[] getTextureCoordinates(int n2) {
        if (n2 >= this.texCoordSetCount || n2 < 0) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo18"));
        }
        return this.texCoordSets[n2];
    }

    public Object[] getTextureCoordinates() {
        return this.texCoordSets[0];
    }

    public void setCoordinateIndices(int[] nArray) {
        this.coordinateIndices = nArray;
    }

    public int[] getCoordinateIndices() {
        return this.coordinateIndices;
    }

    public void setColorIndices(int[] nArray) {
        this.colorIndices = nArray;
    }

    public int[] getColorIndices() {
        return this.colorIndices;
    }

    public void setNormalIndices(int[] nArray) {
        this.normalIndices = nArray;
    }

    public int[] getNormalIndices() {
        return this.normalIndices;
    }

    public void setTextureCoordinateIndices(int n2, int[] nArray) {
        if (n2 >= this.texCoordSetCount || n2 < 0) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo18"));
        }
        this.texCoordIndexSets[n2] = nArray;
    }

    public void setTextureCoordinateIndices(int[] nArray) {
        if (this.texCoordSetCount > 1) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo1"));
        }
        this.texCoordIndexSets = new int[1][];
        this.texCoordIndexSets[0] = nArray;
    }

    public int[] getTextureCoordinateIndices(int n2) {
        return this.texCoordIndexSets[n2];
    }

    public int[] getTextureCoordinateIndices() {
        if (this.texCoordIndexSets == null) {
            return null;
        }
        return this.texCoordIndexSets[0];
    }

    public void setStripCounts(int[] nArray) {
        this.stripCounts = nArray;
    }

    public int[] getStripCounts() {
        return this.stripCounts;
    }

    public void setContourCounts(int[] nArray) {
        this.contourCounts = nArray;
    }

    public int[] getContourCounts() {
        return this.contourCounts;
    }

    int[] getListIndices(Object[] objectArray) {
        int[] nArray = new int[objectArray.length];
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>(objectArray.length);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            Integer n2 = (Integer)hashMap.get(objectArray[i2]);
            if (n2 == null) {
                nArray[i2] = i2;
                hashMap.put(objectArray[i2], new Integer(i2));
                continue;
            }
            nArray[i2] = n2;
        }
        return nArray;
    }

    public void indexify(boolean bl) {
        this.checkForBadData();
        if (bl) {
            int n2;
            int n3;
            if (this.coordOnly) {
                return;
            }
            this.indexify(false);
            int n4 = 1;
            if (this.colorIndices != null) {
                ++n4;
            }
            if (this.normalIndices != null) {
                ++n4;
            }
            n4 += this.texCoordSetCount;
            int n5 = this.coordinateIndices.length;
            Object[] objectArray = new IndexRow[n5];
            for (int i2 = 0; i2 < n5; ++i2) {
                objectArray[i2] = new IndexRow(n4);
                n3 = 0;
                ((IndexRow)objectArray[i2]).set(n3++, this.coordinateIndices[i2]);
                if (this.colorIndices != null) {
                    ((IndexRow)objectArray[i2]).set(n3++, this.colorIndices[i2]);
                }
                if (this.normalIndices != null) {
                    ((IndexRow)objectArray[i2]).set(n3++, this.normalIndices[i2]);
                }
                for (int i3 = 0; i3 < this.texCoordSetCount; ++i3) {
                    ((IndexRow)objectArray[i2]).set(n3++, this.texCoordIndexSets[i3][i2]);
                }
            }
            int[] nArray = this.getListIndices(objectArray);
            int[] nArray2 = new int[nArray.length];
            objectArray = (IndexRow[])this.compactData(nArray, objectArray, nArray2);
            nArray = nArray2;
            Point3f[] point3fArray = new Point3f[objectArray.length];
            Color3f[] color3fArray = null;
            Color4f[] color4fArray = null;
            Vector3f[] vector3fArray = null;
            Object[][] objectArray2 = null;
            if (this.colors3 != null) {
                color3fArray = new Color3f[objectArray.length];
            } else if (this.colors4 != null) {
                color4fArray = new Color4f[objectArray.length];
            }
            if (this.normals != null) {
                vector3fArray = new Vector3f[objectArray.length];
            }
            for (n2 = 0; n2 < this.texCoordSetCount; ++n2) {
                if (this.texCoordDim == 2) {
                    if (n2 == 0) {
                        objectArray2 = new TexCoord2f[this.texCoordSetCount][];
                    }
                    objectArray2[n2] = new TexCoord2f[objectArray.length];
                    continue;
                }
                if (this.texCoordDim == 3) {
                    if (n2 == 0) {
                        objectArray2 = new TexCoord3f[this.texCoordSetCount][];
                    }
                    objectArray2[n2] = new TexCoord3f[objectArray.length];
                    continue;
                }
                if (this.texCoordDim != 4) continue;
                if (n2 == 0) {
                    objectArray2 = new TexCoord4f[this.texCoordSetCount][];
                }
                objectArray2[n2] = new TexCoord4f[objectArray.length];
            }
            n5 = objectArray.length;
            for (n2 = 0; n2 < n5; ++n2) {
                n3 = 0;
                point3fArray[n2] = this.coordinates[((IndexRow)objectArray[n2]).get(n3++)];
                if (this.colors3 != null) {
                    color3fArray[n2] = this.colors3[((IndexRow)objectArray[n2]).get(n3++)];
                } else if (this.colors4 != null) {
                    color4fArray[n2] = this.colors4[((IndexRow)objectArray[n2]).get(n3++)];
                }
                if (this.normals != null) {
                    vector3fArray[n2] = this.normals[((IndexRow)objectArray[n2]).get(n3++)];
                }
                for (int i4 = 0; i4 < this.texCoordSetCount; ++i4) {
                    objectArray2[i4][n2] = this.texCoordSets[i4][((IndexRow)objectArray[n2]).get(n3++)];
                }
            }
            this.coordinates = point3fArray;
            this.colors3 = color3fArray;
            this.colors4 = color4fArray;
            this.normals = vector3fArray;
            this.texCoordSets = objectArray2;
            this.coordinateIndices = nArray;
            this.colorIndices = null;
            this.normalIndices = null;
            this.texCoordIndexSets = new int[this.texCoordSetCount][];
            this.coordOnly = true;
        } else if (this.coordOnly) {
            int n6;
            int n7 = this.coordinateIndices.length;
            if (this.colors3 != null || this.colors4 != null) {
                this.colorIndices = new int[n7];
                for (n6 = 0; n6 < n7; ++n6) {
                    this.colorIndices[n6] = this.coordinateIndices[n6];
                }
            }
            if (this.normals != null) {
                this.normalIndices = new int[n7];
                for (n6 = 0; n6 < n7; ++n6) {
                    this.normalIndices[n6] = this.coordinateIndices[n6];
                }
            }
            this.texCoordIndexSets = new int[this.texCoordSetCount][];
            for (n6 = 0; n6 < this.texCoordSetCount; ++n6) {
                this.texCoordIndexSets[n6] = new int[n7];
                for (int i5 = 0; i5 < n7; ++i5) {
                    this.texCoordIndexSets[n6][i5] = this.coordinateIndices[i5];
                }
            }
            this.coordOnly = false;
        } else {
            if (this.coordinateIndices != null) {
                return;
            }
            this.coordinateIndices = this.getListIndices(this.coordinates);
            if (this.colors3 != null) {
                this.colorIndices = this.getListIndices(this.colors3);
            } else if (this.colors4 != null) {
                this.colorIndices = this.getListIndices(this.colors4);
            }
            if (this.normals != null) {
                this.normalIndices = this.getListIndices(this.normals);
            }
            this.texCoordIndexSets = new int[this.texCoordSetCount][];
            for (int i6 = 0; i6 < this.texCoordSetCount; ++i6) {
                this.texCoordIndexSets[i6] = this.getListIndices(this.texCoordSets[i6]);
            }
            this.coordOnly = false;
        }
    }

    public void indexify() {
        this.indexify(false);
    }

    Object[] allocateArray(Object[] objectArray, int n2) {
        Object[] objectArray2 = null;
        if (objectArray instanceof Point3f[]) {
            objectArray2 = new Point3f[n2];
        } else if (objectArray instanceof Vector3f[]) {
            objectArray2 = new Vector3f[n2];
        } else if (objectArray instanceof Color3f[]) {
            objectArray2 = new Color3f[n2];
        } else if (objectArray instanceof Color4f[]) {
            objectArray2 = new Color4f[n2];
        } else if (objectArray instanceof TexCoord2f[]) {
            objectArray2 = new TexCoord2f[n2];
        } else if (objectArray instanceof TexCoord3f[]) {
            objectArray2 = new TexCoord3f[n2];
        } else if (objectArray instanceof TexCoord4f[]) {
            objectArray2 = new TexCoord4f[n2];
        } else if (objectArray instanceof IndexRow[]) {
            objectArray2 = new IndexRow[n2];
        } else {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo9"));
        }
        return objectArray2;
    }

    private Object[] compactData(int[] nArray, Object[] objectArray, int[] nArray2) {
        int n2;
        int n3;
        Object[] objectArray2 = null;
        int n4 = 0;
        int[] nArray3 = new int[objectArray.length];
        for (n3 = 0; n3 < nArray.length; ++n3) {
            if (nArray3[nArray[n3]] != 0) continue;
            ++n4;
            nArray3[nArray[n3]] = 1;
        }
        objectArray2 = this.allocateArray(objectArray, n4);
        n3 = 0;
        for (n2 = 0; n2 < nArray3.length; ++n2) {
            if (nArray3[n2] == 0) continue;
            objectArray2[n3] = objectArray[n2];
            nArray3[n2] = n3++;
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray2[n2] = nArray3[nArray[n2]];
        }
        return objectArray2;
    }

    public void compact() {
        this.checkForBadData();
        if (this.coordinateIndices == null) {
            return;
        }
        if (this.coordOnly) {
            return;
        }
        int[] nArray = new int[this.coordinateIndices.length];
        this.coordinates = (Point3f[])this.compactData(this.coordinateIndices, this.coordinates, nArray);
        this.coordinateIndices = nArray;
        if (this.colorIndices != null) {
            nArray = new int[this.colorIndices.length];
            if (this.colors3 != null) {
                this.colors3 = (Color3f[])this.compactData(this.colorIndices, this.colors3, nArray);
            } else if (this.colors4 != null) {
                this.colors4 = (Color4f[])this.compactData(this.colorIndices, this.colors4, nArray);
            }
            this.colorIndices = nArray;
        }
        if (this.normalIndices != null) {
            nArray = new int[this.normalIndices.length];
            this.normals = (Vector3f[])this.compactData(this.normalIndices, this.normals, nArray);
            this.normalIndices = nArray;
        }
        for (int i2 = 0; i2 < this.texCoordSetCount; ++i2) {
            nArray = new int[this.texCoordIndexSets[i2].length];
            this.texCoordSets[i2] = this.compactData(this.texCoordIndexSets[i2], this.texCoordSets[i2], nArray);
            this.texCoordIndexSets[i2] = nArray;
        }
    }

    private void checkForBadData() {
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl = false;
        if (this.coordinates == null) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo3"));
        }
        if (this.colors3 == null && this.colors4 == null && this.colorIndices != null) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo4"));
        }
        if (this.normals == null && this.normalIndices != null) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo11"));
        }
        for (n5 = 0; n5 < this.texCoordSetCount; ++n5) {
            if (this.texCoordSets[n5] != null) continue;
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo10"));
        }
        n5 = 0;
        if (this.texCoordIndexSets != null) {
            for (n4 = 0; n4 < this.texCoordSetCount; ++n4) {
                if (this.texCoordIndexSets[n4] == null) continue;
                n5 = 1;
            }
        }
        if (this.coordinateIndices != null || this.colorIndices != null || this.normalIndices != null || n5 != 0) {
            if (this.coordinateIndices == null) {
                bl = true;
            } else if (this.coordOnly) {
                if (this.colorIndices != null || this.normalIndices != null || n5 == 1) {
                    throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo20"));
                }
            } else if ((this.colors3 != null || this.colors4 != null) && this.colorIndices == null) {
                bl = true;
            } else if (this.normals != null && this.normalIndices == null) {
                bl = true;
            } else if (this.texCoordSetCount > 0 && n5 == 0) {
                bl = true;
            }
            if (bl) {
                throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo19"));
            }
        }
        if (this.coordinateIndices != null && !this.coordOnly) {
            if ((this.colors3 != null || this.colors4 != null) && this.colorIndices.length != this.coordinateIndices.length) {
                bl = true;
            } else if (this.normals != null && this.normalIndices.length != this.coordinateIndices.length) {
                bl = true;
            } else {
                for (n4 = 0; n4 < this.texCoordSetCount; ++n4) {
                    if (this.texCoordIndexSets[n4].length == this.coordinateIndices.length) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo5"));
            }
        }
        if (this.prim == 4 || this.prim == 3 || this.prim == 5) {
            if (this.stripCounts == null) {
                bl = true;
            }
        } else if (this.stripCounts != null) {
            bl = true;
        }
        if (bl) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo6"));
        }
        n4 = this.coordinateIndices == null ? this.coordinates.length : this.coordinateIndices.length;
        if (this.prim == 4 || this.prim == 3 || this.prim == 5) {
            n3 = 0;
            for (n2 = 0; n2 < this.stripCounts.length; ++n2) {
                n3 += this.stripCounts[n2];
            }
            if (n3 != n4) {
                throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo7"));
            }
        } else if (this.prim == 1) {
            if (n4 % 3 != 0) {
                throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo12"));
            }
        } else if (this.prim == 2 && n4 % 4 != 0) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo13"));
        }
        if (this.prim == 5) {
            if (this.contourCounts != null) {
                n3 = 0;
                for (n2 = 0; n2 < this.contourCounts.length; ++n2) {
                    n3 += this.contourCounts[n2];
                }
                if (n3 != this.stripCounts.length) {
                    throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo8"));
                }
            }
        } else if (this.contourCounts != null) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfo14"));
        }
    }

    public void unindexify() {
        this.checkForBadData();
        if (this.coordinateIndices != null) {
            if (this.coordOnly) {
                this.indexify(false);
            }
            this.coordinates = (Point3f[])this.unindexifyData(this.coordinates, this.coordinateIndices);
            this.coordinateIndices = null;
            if (this.colors3 != null) {
                this.colors3 = (Color3f[])this.unindexifyData(this.colors3, this.colorIndices);
            } else if (this.colors4 != null) {
                this.colors4 = (Color4f[])this.unindexifyData(this.colors4, this.colorIndices);
            }
            this.colorIndices = null;
            if (this.normals != null) {
                this.normals = (Vector3f[])this.unindexifyData(this.normals, this.normalIndices);
                this.normalIndices = null;
            }
            for (int i2 = 0; i2 < this.texCoordSetCount; ++i2) {
                this.texCoordSets[i2] = this.unindexifyData(this.texCoordSets[i2], this.texCoordIndexSets[i2]);
            }
            this.texCoordIndexSets = new int[this.texCoordSetCount][];
        }
    }

    private Object[] unindexifyData(Object[] objectArray, int[] nArray) {
        Object[] objectArray2 = this.allocateArray(objectArray, nArray.length);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            objectArray2[i2] = objectArray[nArray[i2]];
        }
        return objectArray2;
    }

    private int getVertexFormat() {
        int n2 = 1;
        if (this.colors3 != null) {
            n2 |= 4;
        } else if (this.colors4 != null) {
            n2 |= 0xC;
        }
        if (this.normals != null) {
            n2 |= 2;
        }
        if (this.texCoordDim == 2) {
            n2 |= 0x20;
        } else if (this.texCoordDim == 3) {
            n2 |= 0x40;
        } else if (this.texCoordDim == 4) {
            n2 |= 0x400;
        }
        return n2;
    }

    private int getVertexCount() {
        int n2 = this.coordinates.length;
        if (this.colors3 != null) {
            if (this.colors3.length > n2) {
                n2 = this.colors3.length;
            }
        } else if (this.colors4 != null && this.colors4.length > n2) {
            n2 = this.colors4.length;
        }
        if (this.normals != null && this.normals.length > n2) {
            n2 = this.normals.length;
        }
        for (int i2 = 0; i2 < this.texCoordSetCount; ++i2) {
            if (this.texCoordSets[i2].length <= n2) continue;
            n2 = this.texCoordSets[i2].length;
        }
        return n2;
    }

    private float[] vecmathToFloat(Object[] objectArray) {
        if (objectArray[0] instanceof Tuple2f) {
            float[] fArray = new float[objectArray.length * 2];
            Tuple2f[] tuple2fArray = (Tuple2f[])objectArray;
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                fArray[i2 * 2] = tuple2fArray[i2].x;
                fArray[i2 * 2 + 1] = tuple2fArray[i2].y;
            }
            return fArray;
        }
        if (objectArray[0] instanceof Tuple3f) {
            float[] fArray = new float[objectArray.length * 3];
            Tuple3f[] tuple3fArray = (Tuple3f[])objectArray;
            for (int i3 = 0; i3 < objectArray.length; ++i3) {
                fArray[i3 * 3] = tuple3fArray[i3].x;
                fArray[i3 * 3 + 1] = tuple3fArray[i3].y;
                fArray[i3 * 3 + 2] = tuple3fArray[i3].z;
            }
            return fArray;
        }
        if (objectArray[0] instanceof Tuple4f) {
            float[] fArray = new float[objectArray.length * 4];
            Tuple4f[] tuple4fArray = (Tuple4f[])objectArray;
            for (int i4 = 0; i4 < objectArray.length; ++i4) {
                fArray[i4 * 4] = tuple4fArray[i4].x;
                fArray[i4 * 4 + 1] = tuple4fArray[i4].y;
                fArray[i4 * 4 + 2] = tuple4fArray[i4].z;
                fArray[i4 * 4 + 3] = tuple4fArray[i4].w;
            }
            return fArray;
        }
        return null;
    }

    private void fillIn(GeometryArray geometryArray, boolean bl, boolean bl2, boolean bl3) {
        int n2;
        Object object;
        if (bl2) {
            int n3 = 3;
            if (this.normals != null) {
                n3 += 3;
            }
            if (this.colors3 != null) {
                n3 += 3;
            } else if (this.colors4 != null) {
                n3 += 4;
            }
            object = new float[(n3 += this.texCoordSetCount * this.texCoordDim) * this.coordinates.length];
            n2 = 0;
            for (int i2 = 0; i2 < this.coordinates.length; ++i2) {
                int n4;
                if (this.texCoordDim == 2) {
                    for (n4 = 0; n4 < this.texCoordSetCount; ++n4) {
                        object[n2++] = ((TexCoord2f)this.texCoordSets[n4][i2]).x;
                        object[n2++] = ((TexCoord2f)this.texCoordSets[n4][i2]).y;
                    }
                } else if (this.texCoordDim == 3) {
                    for (n4 = 0; n4 < this.texCoordSetCount; ++n4) {
                        object[n2++] = ((TexCoord3f)this.texCoordSets[n4][i2]).x;
                        object[n2++] = ((TexCoord3f)this.texCoordSets[n4][i2]).y;
                        object[n2++] = ((TexCoord3f)this.texCoordSets[n4][i2]).z;
                    }
                } else if (this.texCoordDim == 4) {
                    for (n4 = 0; n4 < this.texCoordSetCount; ++n4) {
                        object[n2++] = ((TexCoord4f)this.texCoordSets[n4][i2]).x;
                        object[n2++] = ((TexCoord4f)this.texCoordSets[n4][i2]).y;
                        object[n2++] = ((TexCoord4f)this.texCoordSets[n4][i2]).z;
                        object[n2++] = ((TexCoord4f)this.texCoordSets[n4][i2]).w;
                    }
                }
                if (this.colors3 != null) {
                    object[n2++] = this.colors3[i2].x;
                    object[n2++] = this.colors3[i2].y;
                    object[n2++] = this.colors3[i2].z;
                } else if (this.colors4 != null) {
                    object[n2++] = this.colors4[i2].x;
                    object[n2++] = this.colors4[i2].y;
                    object[n2++] = this.colors4[i2].z;
                    object[n2++] = this.colors4[i2].w;
                }
                if (this.normals != null) {
                    object[n2++] = this.normals[i2].x;
                    object[n2++] = this.normals[i2].y;
                    object[n2++] = this.normals[i2].z;
                }
                object[n2++] = this.coordinates[i2].x;
                object[n2++] = this.coordinates[i2].y;
                object[n2++] = this.coordinates[i2].z;
            }
            if (bl3) {
                ByteBufferWrapper byteBufferWrapper = ByteBufferWrapper.allocateDirect(((Object)object).length * 4);
                FloatBufferWrapper floatBufferWrapper = byteBufferWrapper.order(ByteOrderWrapper.nativeOrder()).asFloatBuffer();
                floatBufferWrapper.put((float[])object);
                geometryArray.setInterleavedVertexBuffer(floatBufferWrapper.getJ3DBuffer());
            } else {
                geometryArray.setInterleavedVertices((float[])object);
            }
        } else if (bl3) {
            ByteBufferWrapper byteBufferWrapper = ByteBufferWrapper.allocateDirect(this.coordinates.length * 4 * 3);
            object = byteBufferWrapper.order(ByteOrderWrapper.nativeOrder()).asFloatBuffer();
            ((FloatBufferWrapper)object).put(this.vecmathToFloat(this.coordinates));
            geometryArray.setCoordRefBuffer(((FloatBufferWrapper)object).getJ3DBuffer());
            if (this.colors3 != null) {
                byteBufferWrapper = ByteBufferWrapper.allocateDirect(this.colors3.length * 4 * 3);
                object = byteBufferWrapper.order(ByteOrderWrapper.nativeOrder()).asFloatBuffer();
                ((FloatBufferWrapper)object).put(this.vecmathToFloat(this.colors3));
                geometryArray.setColorRefBuffer(((FloatBufferWrapper)object).getJ3DBuffer());
            } else if (this.colors4 != null) {
                byteBufferWrapper = ByteBufferWrapper.allocateDirect(this.colors4.length * 4 * 4);
                object = byteBufferWrapper.order(ByteOrderWrapper.nativeOrder()).asFloatBuffer();
                ((FloatBufferWrapper)object).put(this.vecmathToFloat(this.colors4));
                geometryArray.setColorRefBuffer(((FloatBufferWrapper)object).getJ3DBuffer());
            }
            if (this.normals != null) {
                byteBufferWrapper = ByteBufferWrapper.allocateDirect(this.normals.length * 4 * 3);
                object = byteBufferWrapper.order(ByteOrderWrapper.nativeOrder()).asFloatBuffer();
                ((FloatBufferWrapper)object).put(this.vecmathToFloat(this.normals));
                geometryArray.setNormalRefBuffer(((FloatBufferWrapper)object).getJ3DBuffer());
            }
            for (n2 = 0; n2 < this.texCoordSetCount; ++n2) {
                byteBufferWrapper = ByteBufferWrapper.allocateDirect(this.texCoordSets[n2].length * 4 * this.texCoordDim);
                object = byteBufferWrapper.order(ByteOrderWrapper.nativeOrder()).asFloatBuffer();
                ((FloatBufferWrapper)object).put(this.vecmathToFloat(this.texCoordSets[n2]));
                geometryArray.setTexCoordRefBuffer(n2, ((FloatBufferWrapper)object).getJ3DBuffer());
            }
        } else if (bl) {
            geometryArray.setCoordRefFloat(this.vecmathToFloat(this.coordinates));
            if (this.colors3 != null) {
                geometryArray.setColorRefFloat(this.vecmathToFloat(this.colors3));
            } else if (this.colors4 != null) {
                geometryArray.setColorRefFloat(this.vecmathToFloat(this.colors4));
            }
            if (this.normals != null) {
                geometryArray.setNormalRefFloat(this.vecmathToFloat(this.normals));
            }
            for (int i3 = 0; i3 < this.texCoordSetCount; ++i3) {
                geometryArray.setTexCoordRefFloat(i3, this.vecmathToFloat(this.texCoordSets[i3]));
            }
        } else {
            geometryArray.setCoordinates(0, this.coordinates);
            if (this.colors3 != null) {
                geometryArray.setColors(0, this.colors3);
            } else if (this.colors4 != null) {
                geometryArray.setColors(0, this.colors4);
            }
            if (this.normals != null) {
                geometryArray.setNormals(0, this.normals);
            }
            for (int i4 = 0; i4 < this.texCoordSetCount; ++i4) {
                if (this.texCoordDim == 2) {
                    geometryArray.setTextureCoordinates(i4, 0, (TexCoord2f[])this.texCoordSets[i4]);
                    continue;
                }
                if (this.texCoordDim == 3) {
                    geometryArray.setTextureCoordinates(i4, 0, (TexCoord3f[])this.texCoordSets[i4]);
                    continue;
                }
                if (this.texCoordDim != 4) continue;
                geometryArray.setTextureCoordinates(i4, 0, (TexCoord4f[])this.texCoordSets[i4]);
            }
        }
        if (this.coordinateIndices != null) {
            IndexedGeometryArray indexedGeometryArray = null;
            indexedGeometryArray = (IndexedGeometryArray)geometryArray;
            indexedGeometryArray.setCoordinateIndices(0, this.coordinateIndices);
            if (!this.coordOnly) {
                if (this.colorIndices != null) {
                    indexedGeometryArray.setColorIndices(0, this.colorIndices);
                }
                if (this.normalIndices != null) {
                    indexedGeometryArray.setNormalIndices(0, this.normalIndices);
                }
                for (int i5 = 0; i5 < this.texCoordSetCount; ++i5) {
                    indexedGeometryArray.setTextureCoordinateIndices(i5, 0, this.texCoordIndexSets[i5]);
                }
            }
        }
    }

    public void recomputeIndices() {
        boolean bl = this.coordOnly;
        this.unindexify();
        this.indexify(bl);
    }

    private void reverseList(int[] nArray) {
        if (nArray == null) {
            return;
        }
        for (int i2 = 0; i2 < nArray.length / 2; ++i2) {
            int n2 = nArray[i2];
            nArray[i2] = nArray[nArray.length - i2 - 1];
            nArray[nArray.length - i2 - 1] = n2;
        }
    }

    public void reverse() {
        this.indexify();
        this.reverseList(this.stripCounts);
        this.reverseList(this.oldStripCounts);
        this.reverseList(this.contourCounts);
        this.reverseList(this.coordinateIndices);
        this.reverseList(this.colorIndices);
        this.reverseList(this.normalIndices);
        for (int i2 = 0; i2 < this.texCoordSetCount; ++i2) {
            this.reverseList(this.texCoordIndexSets[i2]);
        }
    }

    public boolean getUseCoordIndexOnly() {
        return this.coordOnly;
    }

    public void setUseCoordIndexOnly(boolean bl) {
        this.coordOnly = bl;
    }

    public GeometryArray getGeometryArray(boolean bl, boolean bl2, boolean bl3) {
        this.checkForBadData();
        if (this.prim == 5) {
            if (this.tr == null) {
                this.tr = new Triangulator();
            }
            this.tr.triangulate(this);
        } else {
            this.changeBackToOldPrim();
        }
        this.unindexify();
        int n2 = this.getVertexFormat();
        if (bl3) {
            n2 |= 0x880;
        }
        if (bl2) {
            n2 |= 0x180;
        }
        if (bl) {
            n2 |= 0x80;
        }
        int n3 = this.coordinates.length;
        if (this.texCoordSetCount > 0 && this.texCoordSetMap == null) {
            this.texCoordSetCount = 1;
            this.texCoordSetMap = new int[1];
            this.texCoordSetMap[0] = 0;
        }
        GeometryArray geometryArray = null;
        switch (this.prim) {
            case 1: {
                TriangleArray triangleArray;
                geometryArray = triangleArray = new TriangleArray(n3, n2, this.texCoordSetCount, this.texCoordSetMap);
                break;
            }
            case 2: {
                QuadArray quadArray = new QuadArray(n3, n2, this.texCoordSetCount, this.texCoordSetMap);
                geometryArray = quadArray;
                break;
            }
            case 4: {
                TriangleStripArray triangleStripArray = new TriangleStripArray(n3, n2, this.texCoordSetCount, this.texCoordSetMap, this.stripCounts);
                geometryArray = triangleStripArray;
                break;
            }
            case 3: {
                TriangleFanArray triangleFanArray = new TriangleFanArray(n3, n2, this.texCoordSetCount, this.texCoordSetMap, this.stripCounts);
                geometryArray = triangleFanArray;
            }
        }
        this.fillIn(geometryArray, bl, bl2, bl3);
        return geometryArray;
    }

    public GeometryArray getGeometryArray() {
        return this.getGeometryArray(false, false, false);
    }

    public IndexedGeometryArray getIndexedGeometryArray(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        int n2;
        int n3;
        this.indexify(bl4);
        if (bl) {
            this.compact();
        }
        if (this.prim == 5) {
            if (this.tr == null) {
                this.tr = new Triangulator();
            }
            this.tr.triangulate(this);
        } else {
            this.changeBackToOldPrim();
        }
        if (bl4 && !this.coordOnly) {
            boolean bl6 = true;
            if (this.coordinateIndices != null) {
                if (this.colorIndices != null && this.colorIndices.length != this.coordinateIndices.length) {
                    bl6 = false;
                }
                if (this.normalIndices != null && this.normalIndices.length != this.coordinateIndices.length) {
                    bl6 = false;
                }
                for (n3 = 0; n3 < this.texCoordSetCount; ++n3) {
                    if (this.texCoordIndexSets[n3] == null || this.texCoordIndexSets[n3].length == this.coordinateIndices.length) continue;
                    bl6 = false;
                    break;
                }
                if (bl6 && (this.colorIndices != null || this.normalIndices != null || this.texCoordSetCount > 0)) {
                    block7: for (n3 = 0; n3 < this.coordinateIndices.length; ++n3) {
                        int n4 = this.coordinateIndices[n3];
                        if (this.colorIndices != null && this.colorIndices[n3] != n4) {
                            bl6 = false;
                            break;
                        }
                        if (this.normalIndices != null && this.normalIndices[n3] != n4) {
                            bl6 = false;
                            break;
                        }
                        for (n2 = 0; n2 < this.texCoordSetCount; ++n2) {
                            if (this.texCoordIndexSets[n2] == null || this.texCoordIndexSets[n2][n3] == n4) continue;
                            bl6 = false;
                            continue block7;
                        }
                    }
                }
            }
            this.coordOnly = bl6;
        }
        n3 = this.getVertexFormat();
        if (bl5) {
            n3 |= 0x880;
        }
        if (bl3) {
            n3 |= 0x180;
        }
        if (bl2) {
            n3 |= 0x80;
        }
        if (this.coordOnly) {
            n3 |= 0x200;
        }
        n2 = this.getVertexCount();
        if (this.texCoordSetCount > 0 && this.texCoordSetMap == null) {
            this.texCoordSetCount = 1;
            this.texCoordSetMap = new int[1];
            this.texCoordSetMap[0] = 0;
        }
        IndexedGeometryArray indexedGeometryArray = null;
        switch (this.prim) {
            case 1: {
                IndexedTriangleArray indexedTriangleArray;
                indexedGeometryArray = indexedTriangleArray = new IndexedTriangleArray(n2, n3, this.texCoordSetCount, this.texCoordSetMap, this.coordinateIndices.length);
                break;
            }
            case 2: {
                IndexedQuadArray indexedQuadArray = new IndexedQuadArray(n2, n3, this.texCoordSetCount, this.texCoordSetMap, this.coordinateIndices.length);
                indexedGeometryArray = indexedQuadArray;
                break;
            }
            case 4: {
                IndexedTriangleStripArray indexedTriangleStripArray = new IndexedTriangleStripArray(n2, n3, this.texCoordSetCount, this.texCoordSetMap, this.coordinateIndices.length, this.stripCounts);
                indexedGeometryArray = indexedTriangleStripArray;
                break;
            }
            case 3: {
                IndexedTriangleFanArray indexedTriangleFanArray = new IndexedTriangleFanArray(n2, n3, this.texCoordSetCount, this.texCoordSetMap, this.coordinateIndices.length, this.stripCounts);
                indexedGeometryArray = indexedTriangleFanArray;
            }
        }
        this.fillIn(indexedGeometryArray, bl2, bl3, bl5);
        return indexedGeometryArray;
    }

    public IndexedGeometryArray getIndexedGeometryArray(boolean bl) {
        return this.getIndexedGeometryArray(bl, false, false, false, false);
    }

    public IndexedGeometryArray getIndexedGeometryArray() {
        return this.getIndexedGeometryArray(false, false, false, false, false);
    }

    private class IndexRow {
        int[] val;
        int size;
        private static final int HASHCONST = -1161889074;

        public int hashCode() {
            int n2 = 0;
            for (int i2 = 0; i2 < this.size; ++i2) {
                n2 ^= n2 * -1161889074 << 2;
            }
            return n2;
        }

        public boolean equals(Object object) {
            for (int i2 = 0; i2 < this.size; ++i2) {
                if (((IndexRow)object).get(i2) == this.val[i2]) continue;
                return false;
            }
            return true;
        }

        public int get(int n2) {
            return this.val[n2];
        }

        public void set(int n2, int n3) {
            this.val[n2] = n3;
        }

        IndexRow(int n2) {
            this.size = n2;
            this.val = new int[this.size];
        }
    }
}

